function t = setBvTime(m, startTime)
%SETBVTIME Set timephase for Vanthoor greenhouse crop model 
% Should be used after the inputs for m have been defined
% Inputs:
%   m    - a StateSpaceModel object to be used as a Vanthoor model.
%   startTime - time when simulation starts (datenum, days since 0/0/0000)
% Outputs:
%   t - Dynamic element to be placed as m.t

% David Katzin, Wageningen University
% david.katzin@wur.nl
	tStart = m.d.iGlob.val(1,1);
	tEnd = m.d.iGlob.val(end,1);
	
    t = DynamicElement(datestr(startTime), [tStart tEnd], datestr(startTime), []);
end